/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Dynamic;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.ai.AbstractThievesFishAi;
import com.stevekung.fishofthieves.entity.variant.StormfishVariant;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.variant.StormfishVariants;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.LevelData;

public class Stormfish
extends AbstractThievesFish<StormfishVariant> {
    private static final EntityDataAccessor<Holder<StormfishVariant>> VARIANT = SynchedEntityData.defineId(Stormfish.class, FOTDataSerializers.STORMFISH_VARIANT);
    public static final BiMap<String, Integer> VARIANT_TO_INT = (BiMap)Util.make((Object)HashBiMap.create(), map -> {
        map.put((Object)"fishofthieves:ancient", (Object)0);
        map.put((Object)"fishofthieves:shores", (Object)1);
        map.put((Object)"fishofthieves:wild", (Object)2);
        map.put((Object)"fishofthieves:shadow", (Object)3);
        map.put((Object)"fishofthieves:twilight", (Object)4);
    });

    public Stormfish(EntityType<? extends Stormfish> entityType, Level level) {
        super(entityType, level, FOTRegistries.STORMFISH_VARIANT, StormfishVariants.ANCIENT);
    }

    protected Brain.Provider<AbstractThievesFish<?>> brainProvider() {
        return Brain.provider((Collection)MEMORY_TYPES, Stream.of(SENSOR_TYPES, List.of(FOTSensorTypes.LEECHES_THIEVES_FISH_TEMPTATIONS)).flatMap(Collection::stream).toList());
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return AbstractThievesFishAi.makeBrain(this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Stormfish> getBrain() {
        return super.getBrain();
    }

    protected void customServerAiStep() {
        AbstractThievesFishAi.customServerAiStep(this, this.getBrain());
        super.customServerAiStep();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)this.registryAccess().registryOrThrow(FOTRegistries.STORMFISH_VARIANT).getHolderOrThrow(StormfishVariants.ANCIENT));
    }

    public Holder<StormfishVariant> getVariant() {
        return (Holder)this.entityData.get(VARIANT);
    }

    public void setVariant(Holder<StormfishVariant> variant) {
        this.entityData.set(VARIANT, variant);
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)FOTItems.STORMFISH_BUCKET);
    }

    protected SoundEvent getDeathSound() {
        return FOTSoundEvents.STORMFISH_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return FOTSoundEvents.STORMFISH_HURT;
    }

    protected SoundEvent getFlopSound() {
        return FOTSoundEvents.STORMFISH_FLOP;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isTrophy() ? super.getDefaultDimensions(pose).withEyeHeight(0.225f) : EntityDimensions.fixed((float)0.4f, (float)0.3f).withEyeHeight(0.11f);
    }

    public void thunderHit(ServerLevel level, LightningBolt lightning) {
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return LEECHES_FOOD.test(itemStack);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            BlockPos pos = this.blockPosition();
            if (this.level().isThundering() && (long)this.random.nextInt(200) <= this.level().getGameTime() % 200L && pos.getY() == this.level().getHeight(Heightmap.Types.WORLD_SURFACE, pos.getX(), pos.getZ()) - 1) {
                this.level().addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, this.getRandomX(0.6), this.getRandomY(), this.getRandomZ(0.6), 0.0, 0.0, 0.0);
            }
        }
    }

    public static boolean checkSpawnRules(EntityType<? extends WaterAnimal> entityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource random) {
        boolean isWater = level.getFluidState(blockPos.below()).is(FluidTags.WATER) && level.getBlockState(blockPos.above()).is(Blocks.WATER);
        LevelData levelData = level.getLevelData();
        return isWater && levelData.isRaining() && levelData.isThundering() && level.canSeeSkyFromBelowWater(blockPos);
    }
}

